//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Remove Recipes
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
// Contributors: ShiftTheDev, ChosenArchitect
//
// Removes recipes based on different factors, it also fixes problems with automatic recipe generation from Create by changing the IDs of some
// recipes and suffixing them with '_manual_only'
//------------------------------------------------------------------------------------------------------------------------------------------------

// Remove by Output
// - Add the item id of the output item of the recipe and all recipes with that output will be removed
const byOutput = [
	"quark:obsidian_pressure_plate",
	"cyclic:compressed_cobblestone",
	"jaopca:storage_blocks.brick",
	"jaopca:storage_blocks.fluix",
	"jaopca:storage_blocks.glowstone",
	"jaopca:storage_blocks.brick",
	"jaopca:storage_blocks.nether_brick",
	"jaopca:storage_blocks.wood",
	/chisel_chipped_integration:metal_aluminum_.*/,
	/chisel_chipped_integration:metal_cobalt_.*/,
	/chisel_chipped_integration:metal_platinum_.*/,
	"architects_palette:charcoal_block",
    "#projectexpansion:collector",
    "#projectexpansion:compressed_collector",
    "#projectexpansion:power_flower",
    "#projectexpansion:relay",
    "plushies:warden_plushie",
    "plushies:bee_plushie",
    "plushies:dragon_plushie",
    "plushies:wither_plushie",
    "plushies:evoker_plushie",
    "plushies:pig_plushie",
    "plushies:elder_guardian_plushie",
    "plushies:sniffer_plushie",
    "plushies:axolotl_plushie",
    "plushies:goat_plushie",
    "projectexpansion:transmutation_interface",
    "cyclic:ender_book",
    "cyclic:storage_bag",
    "cyclic:tile_transporter_empty",
    "cyclic:magic_net",
    "cyclic:energy_pipe",
    "cyclic:item_pipe",
    "cyclic:fluid_pipe",
    "cyclic:anvil_void",
    "cyclic:uncrafter",
    "cyclic:disenchanter",
    "cyclic:experience_pylon",
    "cyclic:no_soliciting",
    "cyclic:no_soliciting",
    "trials:crafter",
    "rftoolsdim:empty_dimension_tab",
    "cyclic:crafting_stick",
    "projecte:watch_of_flowing_time",
    "createaddition:zinc_sheet",
    "utilitarian:snad",
    "utilitarian:red_snad",
    "utilitarian:soul_snad",
    "utilitix:backpack",
    "cyclic:crafter",
    "createdeco:netherite_nugget"
]

// Remove by ID
// - Add the recipe id for the recipe to remove
const byId = [
	// Compact Suns don't work with the normal collectors of ProjectE, and the ones from ProjectExpansion are disabled,
	// this only follows the logic.
    "projectexpansion:compact_sun_1",
	"projectexpansion:compact_sun_2",
	"reliquary:reliquary.fragment_to_spawn_egg.item.minecraft.chicken_spawn_egg",
	"outer_end:violite/bricks/slab_from_vertical_slab",
	"outer_end:himmel_vertical_to_slab",
	"outer_end:violite/tiles/slab_from_vertical_slab",
	"outer_end:violite/mossy_tiles/slab_from_vertical_slab",
	"outer_end:azure_vertical_to_planks",
	"outer_end:violite/mossy_bricks/slab_from_vertical_slab",
	"outer_end:violite/slab_from_vertical_slab",
	"outer_end:azure_vertical_to_slab",
	"allthecompressed:compress/invar_block_1x",
    "allthecompressed:compress/invar_block_2x",
    "allthecompressed:compress/invar_block_3x",
    "allthecompressed:compress/invar_block_4x",
    "allthecompressed:compress/invar_block_5x",
    "allthecompressed:compress/invar_block_6x",
    "allthecompressed:compress/invar_block_7x",
    "allthecompressed:compress/invar_block_8x",
    "allthecompressed:compress/invar_block_9x",
    "allthecompressed:compress/soularium_block_1x",
    "allthecompressed:compress/soularium_block_2x",
    "allthecompressed:compress/soularium_block_3x",
    "allthecompressed:compress/soularium_block_4x",
    "allthecompressed:compress/soularium_block_5x",
    "allthecompressed:compress/soularium_block_6x",
    "allthecompressed:compress/soularium_block_7x",
    "allthecompressed:compress/soularium_block_8x",
    "allthecompressed:compress/soularium_block_9x",
    "allthecompressed:compress/ender_pearl_block_1x",
    "allthecompressed:compress/ender_pearl_block_2x",
    "allthecompressed:compress/ender_pearl_block_3x",
    "allthecompressed:compress/ender_pearl_block_4x",
    "allthecompressed:compress/ender_pearl_block_5x",
    "allthecompressed:compress/ender_pearl_block_6x",
    "allthecompressed:compress/ender_pearl_block_7x",
    "allthecompressed:compress/ender_pearl_block_8x",
    "allthecompressed:compress/ender_pearl_block_9x",
    "allthecompressed:compress/copper_alloy_block_1x",
    "allthecompressed:compress/copper_alloy_block_2x",
    "allthecompressed:compress/copper_alloy_block_3x",
    "allthecompressed:compress/copper_alloy_block_4x",
    "allthecompressed:compress/copper_alloy_block_5x",
    "allthecompressed:compress/copper_alloy_block_6x",
    "allthecompressed:compress/copper_alloy_block_7x",
    "allthecompressed:compress/copper_alloy_block_8x",
    "allthecompressed:compress/copper_alloy_block_9x",
    "allthecompressed:compress/silver_block_1x",
    "allthecompressed:compress/silver_block_2x",
    "allthecompressed:compress/silver_block_3x",
    "allthecompressed:compress/silver_block_4x",
    "allthecompressed:compress/silver_block_5x",
    "allthecompressed:compress/silver_block_6x",
    "allthecompressed:compress/silver_block_7x",
    "allthecompressed:compress/silver_block_8x",
    "allthecompressed:compress/silver_block_9x",
    "allthecompressed:compress/tin_block_1x",
    "allthecompressed:compress/tin_block_2x",
    "allthecompressed:compress/tin_block_3x",
    "allthecompressed:compress/tin_block_4x",
    "allthecompressed:compress/tin_block_5x",
    "allthecompressed:compress/tin_block_6x",
    "allthecompressed:compress/tin_block_7x",
    "allthecompressed:compress/tin_block_8x",
    "allthecompressed:compress/tin_block_9x",
    "allthecompressed:compress/lumium_block_1x",
    "allthecompressed:compress/lumium_block_2x",
    "allthecompressed:compress/lumium_block_3x",
    "allthecompressed:compress/lumium_block_4x",
    "allthecompressed:compress/lumium_block_5x",
    "allthecompressed:compress/lumium_block_6x",
    "allthecompressed:compress/lumium_block_7x",
    "allthecompressed:compress/lumium_block_8x",
    "allthecompressed:compress/lumium_block_9x",
    "allthecompressed:compress/blaze_block_1x",
    "allthecompressed:compress/blaze_block_2x",
    "allthecompressed:compress/blaze_block_3x",
    "allthecompressed:compress/blaze_block_4x",
    "allthecompressed:compress/blaze_block_5x",
    "allthecompressed:compress/blaze_block_6x",
    "allthecompressed:compress/blaze_block_7x",
    "allthecompressed:compress/blaze_block_8x",
    "allthecompressed:compress/blaze_block_9x",
    "allthecompressed:compress/atm_star_block_1x",
    "allthecompressed:compress/atm_star_block_2x",
    "allthecompressed:compress/atm_star_block_3x",
    "allthecompressed:compress/atm_star_block_4x",
    "allthecompressed:compress/atm_star_block_5x",
    "allthecompressed:compress/atm_star_block_6x",
    "allthecompressed:compress/atm_star_block_7x",
    "allthecompressed:compress/atm_star_block_8x",
    "allthecompressed:compress/atm_star_block_9x",
    "allthecompressed:compress/redstone_alloy_block_1x",
    "allthecompressed:compress/redstone_alloy_block_2x",
    "allthecompressed:compress/redstone_alloy_block_3x",
    "allthecompressed:compress/redstone_alloy_block_4x",
    "allthecompressed:compress/redstone_alloy_block_5x",
    "allthecompressed:compress/redstone_alloy_block_6x",
    "allthecompressed:compress/redstone_alloy_block_7x",
    "allthecompressed:compress/redstone_alloy_block_8x",
    "allthecompressed:compress/redstone_alloy_block_9x",
    "allthecompressed:compress/pulsating_alloy_block_1x",
    "allthecompressed:compress/pulsating_alloy_block_2x",
    "allthecompressed:compress/pulsating_alloy_block_3x",
    "allthecompressed:compress/pulsating_alloy_block_4x",
    "allthecompressed:compress/pulsating_alloy_block_5x",
    "allthecompressed:compress/pulsating_alloy_block_6x",
    "allthecompressed:compress/pulsating_alloy_block_7x",
    "allthecompressed:compress/pulsating_alloy_block_8x",
    "allthecompressed:compress/pulsating_alloy_block_9x",
    "allthecompressed:compress/aluminum_block_1x",
    "allthecompressed:compress/aluminum_block_2x",
    "allthecompressed:compress/aluminum_block_3x",
    "allthecompressed:compress/aluminum_block_4x",
    "allthecompressed:compress/aluminum_block_5x",
    "allthecompressed:compress/aluminum_block_6x",
    "allthecompressed:compress/aluminum_block_7x",
    "allthecompressed:compress/aluminum_block_8x",
    "allthecompressed:compress/aluminum_block_9x",
    "allthecompressed:compress/steel_block_1x",
    "allthecompressed:compress/steel_block_2x",
    "allthecompressed:compress/steel_block_3x",
    "allthecompressed:compress/steel_block_4x",
    "allthecompressed:compress/steel_block_5x",
    "allthecompressed:compress/steel_block_6x",
    "allthecompressed:compress/steel_block_7x",
    "allthecompressed:compress/steel_block_8x",
    "allthecompressed:compress/steel_block_9x",
    "allthecompressed:compress/peridot_block_1x",
    "allthecompressed:compress/peridot_block_2x",
    "allthecompressed:compress/peridot_block_3x",
    "allthecompressed:compress/peridot_block_4x",
    "allthecompressed:compress/peridot_block_5x",
    "allthecompressed:compress/peridot_block_6x",
    "allthecompressed:compress/peridot_block_7x",
    "allthecompressed:compress/peridot_block_8x",
    "allthecompressed:compress/peridot_block_9x",
    "allthecompressed:compress/energetic_alloy_block_1x",
    "allthecompressed:compress/energetic_alloy_block_2x",
    "allthecompressed:compress/energetic_alloy_block_3x",
    "allthecompressed:compress/energetic_alloy_block_4x",
    "allthecompressed:compress/energetic_alloy_block_5x",
    "allthecompressed:compress/energetic_alloy_block_6x",
    "allthecompressed:compress/energetic_alloy_block_7x",
    "allthecompressed:compress/energetic_alloy_block_8x",
    "allthecompressed:compress/energetic_alloy_block_9x",
    "allthecompressed:compress/osmium_block_1x",
    "allthecompressed:compress/osmium_block_2x",
    "allthecompressed:compress/osmium_block_3x",
    "allthecompressed:compress/osmium_block_4x",
    "allthecompressed:compress/osmium_block_5x",
    "allthecompressed:compress/osmium_block_6x",
    "allthecompressed:compress/osmium_block_7x",
    "allthecompressed:compress/osmium_block_8x",
    "allthecompressed:compress/osmium_block_9x",
    "allthecompressed:compress/allthemodium_block_1x",
    "allthecompressed:compress/allthemodium_block_2x",
    "allthecompressed:compress/allthemodium_block_3x",
    "allthecompressed:compress/allthemodium_block_4x",
    "allthecompressed:compress/allthemodium_block_5x",
    "allthecompressed:compress/allthemodium_block_6x",
    "allthecompressed:compress/allthemodium_block_7x",
    "allthecompressed:compress/allthemodium_block_8x",
    "allthecompressed:compress/allthemodium_block_9x",
    "allthecompressed:compress/vibranium_block_1x",
    "allthecompressed:compress/vibranium_block_2x",
    "allthecompressed:compress/vibranium_block_3x",
    "allthecompressed:compress/vibranium_block_4x",
    "allthecompressed:compress/vibranium_block_5x",
    "allthecompressed:compress/vibranium_block_6x",
    "allthecompressed:compress/vibranium_block_7x",
    "allthecompressed:compress/vibranium_block_8x",
    "allthecompressed:compress/vibranium_block_9x",
    "allthecompressed:compress/ruby_block_1x",
    "allthecompressed:compress/ruby_block_2x",
    "allthecompressed:compress/ruby_block_3x",
    "allthecompressed:compress/ruby_block_4x",
    "allthecompressed:compress/ruby_block_5x",
    "allthecompressed:compress/ruby_block_6x",
    "allthecompressed:compress/ruby_block_7x",
    "allthecompressed:compress/ruby_block_8x",
    "allthecompressed:compress/ruby_block_9x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_1x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_2x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_3x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_4x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_5x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_6x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_7x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_8x",
    "allthecompressed:compress/vibranium_allthemodium_alloy_block_9x",
    "allthecompressed:compress/platinum_block_1x",
    "allthecompressed:compress/platinum_block_2x",
    "allthecompressed:compress/platinum_block_3x",
    "allthecompressed:compress/platinum_block_4x",
    "allthecompressed:compress/platinum_block_5x",
    "allthecompressed:compress/platinum_block_6x",
    "allthecompressed:compress/platinum_block_7x",
    "allthecompressed:compress/platinum_block_8x",
    "allthecompressed:compress/platinum_block_9x",
    "allthecompressed:compress/unobtainium_block_1x",
    "allthecompressed:compress/unobtainium_block_2x",
    "allthecompressed:compress/unobtainium_block_3x",
    "allthecompressed:compress/unobtainium_block_4x",
    "allthecompressed:compress/unobtainium_block_5x",
    "allthecompressed:compress/unobtainium_block_6x",
    "allthecompressed:compress/unobtainium_block_7x",
    "allthecompressed:compress/unobtainium_block_8x",
    "allthecompressed:compress/unobtainium_block_9x",
    "allthecompressed:compress/end_steel_block_1x",
    "allthecompressed:compress/end_steel_block_2x",
    "allthecompressed:compress/end_steel_block_3x",
    "allthecompressed:compress/end_steel_block_4x",
    "allthecompressed:compress/end_steel_block_5x",
    "allthecompressed:compress/end_steel_block_6x",
    "allthecompressed:compress/end_steel_block_7x",
    "allthecompressed:compress/end_steel_block_8x",
    "allthecompressed:compress/end_steel_block_9x",
    "allthecompressed:compress/vibrant_alloy_block_1x",
    "allthecompressed:compress/vibrant_alloy_block_2x",
    "allthecompressed:compress/vibrant_alloy_block_3x",
    "allthecompressed:compress/vibrant_alloy_block_4x",
    "allthecompressed:compress/vibrant_alloy_block_5x",
    "allthecompressed:compress/vibrant_alloy_block_6x",
    "allthecompressed:compress/vibrant_alloy_block_7x",
    "allthecompressed:compress/vibrant_alloy_block_8x",
    "allthecompressed:compress/vibrant_alloy_block_9x",
    "allthecompressed:compress/enderium_block_1x",
    "allthecompressed:compress/enderium_block_2x",
    "allthecompressed:compress/enderium_block_3x",
    "allthecompressed:compress/enderium_block_4x",
    "allthecompressed:compress/enderium_block_5x",
    "allthecompressed:compress/enderium_block_6x",
    "allthecompressed:compress/enderium_block_7x",
    "allthecompressed:compress/enderium_block_8x",
    "allthecompressed:compress/enderium_block_9x",
    "allthecompressed:compress/ancient_log_0_1x",
    "allthecompressed:compress/ancient_log_0_2x",
    "allthecompressed:compress/ancient_log_0_3x",
    "allthecompressed:compress/ancient_log_0_4x",
    "allthecompressed:compress/ancient_log_0_5x",
    "allthecompressed:compress/ancient_log_0_6x",
    "allthecompressed:compress/ancient_log_0_7x",
    "allthecompressed:compress/ancient_log_0_8x",
    "allthecompressed:compress/ancient_log_0_9x",
    "allthecompressed:compress/wax_block_1x",
    "allthecompressed:compress/wax_block_2x",
    "allthecompressed:compress/wax_block_3x",
    "allthecompressed:compress/wax_block_4x",
    "allthecompressed:compress/wax_block_5x",
    "allthecompressed:compress/wax_block_6x",
    "allthecompressed:compress/wax_block_7x",
    "allthecompressed:compress/wax_block_8x",
    "allthecompressed:compress/wax_block_9x",
    "allthecompressed:compress/lead_block_1x",
    "allthecompressed:compress/lead_block_2x",
    "allthecompressed:compress/lead_block_3x",
    "allthecompressed:compress/lead_block_4x",
    "allthecompressed:compress/lead_block_5x",
    "allthecompressed:compress/lead_block_6x",
    "allthecompressed:compress/lead_block_7x",
    "allthecompressed:compress/lead_block_8x",
    "allthecompressed:compress/lead_block_9x",
    "allthecompressed:compress/zinc_block_1x",
    "allthecompressed:compress/zinc_block_2x",
    "allthecompressed:compress/zinc_block_3x",
    "allthecompressed:compress/zinc_block_4x",
    "allthecompressed:compress/zinc_block_5x",
    "allthecompressed:compress/zinc_block_6x",
    "allthecompressed:compress/zinc_block_7x",
    "allthecompressed:compress/zinc_block_8x",
    "allthecompressed:compress/zinc_block_9x",
    "allthecompressed:compress/iridium_block_1x",
    "allthecompressed:compress/iridium_block_2x",
    "allthecompressed:compress/iridium_block_3x",
    "allthecompressed:compress/iridium_block_4x",
    "allthecompressed:compress/iridium_block_5x",
    "allthecompressed:compress/iridium_block_6x",
    "allthecompressed:compress/iridium_block_7x",
    "allthecompressed:compress/iridium_block_8x",
    "allthecompressed:compress/iridium_block_9x",
    "allthecompressed:compress/conductive_alloy_block_1x",
    "allthecompressed:compress/conductive_alloy_block_2x",
    "allthecompressed:compress/conductive_alloy_block_3x",
    "allthecompressed:compress/conductive_alloy_block_4x",
    "allthecompressed:compress/conductive_alloy_block_5x",
    "allthecompressed:compress/conductive_alloy_block_6x",
    "allthecompressed:compress/conductive_alloy_block_7x",
    "allthecompressed:compress/conductive_alloy_block_8x",
    "allthecompressed:compress/conductive_alloy_block_9x",
    "allthecompressed:compress/bronze_block_1x",
    "allthecompressed:compress/bronze_block_2x",
    "allthecompressed:compress/bronze_block_3x",
    "allthecompressed:compress/bronze_block_4x",
    "allthecompressed:compress/bronze_block_5x",
    "allthecompressed:compress/bronze_block_6x",
    "allthecompressed:compress/bronze_block_7x",
    "allthecompressed:compress/bronze_block_8x",
    "allthecompressed:compress/bronze_block_9x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_1x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_2x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_3x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_4x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_5x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_6x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_7x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_8x",
    "allthecompressed:compress/unobtainium_vibranium_alloy_block_9x",
    "allthecompressed:compress/sapphire_block_1x",
    "allthecompressed:compress/sapphire_block_2x",
    "allthecompressed:compress/sapphire_block_3x",
    "allthecompressed:compress/sapphire_block_4x",
    "allthecompressed:compress/sapphire_block_5x",
    "allthecompressed:compress/sapphire_block_6x",
    "allthecompressed:compress/sapphire_block_7x",
    "allthecompressed:compress/sapphire_block_8x",
    "allthecompressed:compress/sapphire_block_9x",
    "allthecompressed:compress/ancient_stone_1x",
    "allthecompressed:compress/ancient_stone_2x",
    "allthecompressed:compress/ancient_stone_3x",
    "allthecompressed:compress/ancient_stone_4x",
    "allthecompressed:compress/ancient_stone_5x",
    "allthecompressed:compress/ancient_stone_6x",
    "allthecompressed:compress/ancient_stone_7x",
    "allthecompressed:compress/ancient_stone_8x",
    "allthecompressed:compress/ancient_stone_9x",
    "allthecompressed:compress/signalum_block_1x",
    "allthecompressed:compress/signalum_block_2x",
    "allthecompressed:compress/signalum_block_3x",
    "allthecompressed:compress/signalum_block_4x",
    "allthecompressed:compress/signalum_block_5x",
    "allthecompressed:compress/signalum_block_6x",
    "allthecompressed:compress/signalum_block_7x",
    "allthecompressed:compress/signalum_block_8x",
    "allthecompressed:compress/signalum_block_9x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_1x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_2x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_3x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_4x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_5x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_6x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_7x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_8x",
    "allthecompressed:compress/unobtainium_allthemodium_alloy_block_9x",
    "allthecompressed:compress/constantan_block_1x",
    "allthecompressed:compress/constantan_block_2x",
    "allthecompressed:compress/constantan_block_3x",
    "allthecompressed:compress/constantan_block_4x",
    "allthecompressed:compress/constantan_block_5x",
    "allthecompressed:compress/constantan_block_6x",
    "allthecompressed:compress/constantan_block_7x",
    "allthecompressed:compress/constantan_block_8x",
    "allthecompressed:compress/constantan_block_9x",
    "allthecompressed:compress/nickel_block_1x",
    "allthecompressed:compress/nickel_block_2x",
    "allthecompressed:compress/nickel_block_3x",
    "allthecompressed:compress/nickel_block_4x",
    "allthecompressed:compress/nickel_block_5x",
    "allthecompressed:compress/nickel_block_6x",
    "allthecompressed:compress/nickel_block_7x",
    "allthecompressed:compress/nickel_block_8x",
    "allthecompressed:compress/nickel_block_9x",
    "allthecompressed:compress/electrum_block_1x",
    "allthecompressed:compress/electrum_block_2x",
    "allthecompressed:compress/electrum_block_3x",
    "allthecompressed:compress/electrum_block_4x",
    "allthecompressed:compress/electrum_block_5x",
    "allthecompressed:compress/electrum_block_6x",
    "allthecompressed:compress/electrum_block_7x",
    "allthecompressed:compress/electrum_block_8x",
    "allthecompressed:compress/electrum_block_9x",
    "allthecompressed:compress/dark_steel_block_1x",
    "allthecompressed:compress/dark_steel_block_2x",
    "allthecompressed:compress/dark_steel_block_3x",
    "allthecompressed:compress/dark_steel_block_4x",
    "allthecompressed:compress/dark_steel_block_5x",
    "allthecompressed:compress/dark_steel_block_6x",
    "allthecompressed:compress/dark_steel_block_7x",
    "allthecompressed:compress/dark_steel_block_8x",
    "allthecompressed:compress/dark_steel_block_9x",
    "allthecompressed:compress/uranium_block_1x",
    "allthecompressed:compress/uranium_block_2x",
    "allthecompressed:compress/uranium_block_3x",
    "allthecompressed:compress/uranium_block_4x",
    "allthecompressed:compress/uranium_block_5x",
    "allthecompressed:compress/uranium_block_6x",
    "allthecompressed:compress/uranium_block_7x",
    "allthecompressed:compress/uranium_block_8x",
    "allthecompressed:compress/uranium_block_9x",
    "allthecompressed:compress/nether_star_block_1x",
    "allthecompressed:compress/nether_star_block_2x",
    "allthecompressed:compress/nether_star_block_3x",
    "allthecompressed:compress/nether_star_block_4x",
    "allthecompressed:compress/nether_star_block_5x",
    "allthecompressed:compress/nether_star_block_6x",
    "allthecompressed:compress/nether_star_block_7x",
    "allthecompressed:compress/nether_star_block_8x",
    "allthecompressed:compress/nether_star_block_9x",
	"moredelight:farmersdelight/cutting/bread_slice",
    "industrialforegoing:dryrubber",
    "enlightened_end:cerulean_planks",
    "spelunkers_charm:redstone_geyser_recipe",
    "outer_end:violite/tiles/vertical_slab_stonecutting",
    "allthecompressed:decompress/vibranium_allthemodium_alloy_block_1x",
    "allthecompressed:decompress/platinum_block_1x",
    "allthecompressed:decompress/zinc_block_1x",
    "allthecompressed:decompress/invar_block_1x",
    "mekaweapons:module_arrowvelocity_unit",
    "allthecompressed:decompress/tin_block_1x",
    "allthecompressed:decompress/constantan_block_1x",
    "allthecompressed:decompress/peridot_block_1x",
    "allthecompressed:decompress/dark_steel_block_1x",
    "outer_end:himmel_vertical_slab_stonecutting",
    "outer_end:violite/tiles/vertical_slab",
    "allthecompressed:decompress/nether_star_block_1x",
    "allthecompressed:decompress/soularium_block_1x",
    "outer_end:azure_vertical_planks",
    "outer_end:violite/vertical_slab",
    "allthecompressed:decompress/unobtainium_vibranium_alloy_block_1x",
    "outer_end:violite/bricks/vertical_slab_violite_stonecutting",
    "allthecompressed:decompress/atm_star_block_1x",
    "outer_end:violite/vertical_slab_stonecutting",
    "allthecompressed:decompress/steel_block_1x",
    "allthecompressed:decompress/unobtainium_allthemodium_alloy_block_1x",
    "outer_end:violite/mossy_bricks/vertical_slab",
    "allthecompressed:decompress/ancient_stone_1x",
    "outer_end:himmel_vertical_slab",
    "outer_end:violite/mossy_bricks/vertical_slab_stonecutting",
    "allthecompressed:decompress/bronze_block_1x",
    "outer_end:violite/mossy_tiles/vertical_slab_stonecutting",
    "allthecompressed:decompress/vibrant_alloy_block_1x",
    "allthecompressed:decompress/conductive_alloy_block_1x",
    "allthecompressed:decompress/unobtainium_block_1x",
    "allthecompressed:decompress/redstone_alloy_block_1x",
    "outer_end:violite/tiles/vertical_slab_from_violite_stonecutting",
    "outer_end:stripped_azure_post",
    "enlightened_end:smithing/adamantite_knife",
    "outer_end:violite/bricks/vertical_slab_stonecutting",
    "allthecompressed:decompress/ender_pearl_block_1x",
    "allthecompressed:decompress/copper_alloy_block_1x",
    "chipped_express:stonecutting_chipped_course_sand_from_sand",
    "incendium:upgrade_elytra",
    "allthecompressed:decompress/sapphire_block_1x",    
    "allthecompressed:decompress/uranium_block_1x",
    "allthecompressed:decompress/enderium_block_1x",
    "allthecompressed:decompress/osmium_block_1x",
    "allthecompressed:decompress/energetic_alloy_block_1x",
    "outer_end:azure_vertical_slab",
    "allthecompressed:decompress/lead_block_1x",
    "allthecompressed:decompress/allthemodium_block_1x",
    "allthecompressed:decompress/lumium_block_1x",
    "outer_end:azure_post",
    "allthecompressed:decompress/blaze_block_1x",
    "allthecompressed:decompress/wax_block_1x",
    "allthecompressed:decompress/ancient_log_0_1x",
    "allthecompressed:decompress/signalum_block_1x",
    "outer_end:violite/mossy_tiles/vertical_slab",
    "allthecompressed:decompress/electrum_block_1x",
    "allthecompressed:decompress/pulsating_alloy_block_1x",
    "allthecompressed:decompress/aluminum_block_1x",
    "allthecompressed:decompress/end_steel_block_1x",
    "allthecompressed:decompress/iridium_block_1x",
    "allthecompressed:decompress/vibranium_block_1x",
    "jaopca:storage_blocks.to_storage_block.arcane_gold",
    "jaopca:storage_blocks.to_material.arcane_gold",
    "jaopca:thermal_expansion.storage_block_to_material.arcane_gold",
    "jaopca:thermal_expansion.material_to_storage_block.arcane_gold",
    "projectexpansion:star/final_star_shard",
    "projectexpansion:star/final_star",
    "expatternprovider:cobblestone_cell",
    "deeperdarker:raw_iron_from_smelting_gloomslate_iron_ore",
    "deeperdarker:raw_iron_from_blasting_gloomslate_iron_ore",
    "deeperdarker:raw_copper_from_smelting_gloomslate_copper_ore",
    "deeperdarker:raw_copper_from_blasting_gloomslate_copper_ore",
    "deeperdarker:raw_gold_from_smelting_gloomslate_gold_ore",
    "deeperdarker:raw_gold_from_blasting_gloomslate_gold_ore",
	"industrialforegoing:iron_gear",
	"industrialforegoing:gold_gear",
	"industrialforegoing:diamond_gear",
	"refinedstorage:quartz_enriched_iron",
	"cyclic:crafting/chest",
	"minecraft:dispenser",
    "cyclic:crafting/nether_wart_reverse",
    "projectexpansion:matter/fading",
    "projectexpansion:matter/fading_alt",
    "projecte:gem_leggings",
    "projectexpansion:matter_upgrader_1",
    "projectexpansion:matter_upgrader_2",
    "mekanism:metallurgic_infusing/allthecompressed/iron/1x_to_1x_steel",
    "jaopca:thermal_expansion.material_to_plate.zinc",
	"create:crushing/asurine",
	"create:crushing/asurine_recycling",
	"thermal:compat/create/pulverizer_create_asurine",
	"thermal:compat/create/pulverizer_create_asurine_recycle",
	"create:crushing/crimsite",
	"create:crushing/crimsite_recycling",
	"thermal:compat/create/pulverizer_create_crimsite",
	"thermal:compat/create/pulverizer_create_crimsite_recycle",
	"create:crushing/ochrum",
	"create:crushing/ochrum_recycling",
	"thermal:compat/create/pulverizer_create_ochrum",
	"thermal:compat/create/pulverizer_create_ochrum_recycle",
	"create:crushing/veridium",
	"create:crushing/veridium_recycling",
	"thermal:compat/create/pulverizer_create_veridium",
	"thermal:compat/create/pulverizer_create_veridium_recycle",
    "jaopca:thermal_expansion.storage_block_to_material.source",
    "jaopca:thermal_expansion.material_to_storage_block.source",
    "biggerreactors:smelting/uranium_chunk",
    "biggerreactors:compat/mekanism/enriching/enrichment_uranium_chunk",
    "createdeco:netherite_ingot",
    "cyclic:netherite_ingot",
    "sophisticatedstorage:oak_chest_from_vanilla_chest",
    "create:industrial_iron_block_from_ingots_iron_stonecutting",
    "jaopca:thermal_expansion.dust_to_material.zinc",
	"jaopca:thermal_expansion.dust_to_material.abyssal",
	"jaopca:thermal_expansion.dust_to_material.dragonsteel",
	"jaopca:thermal_expansion.dust_to_material.shellite",
	"jaopca:thermal_expansion.dust_to_material.soul_infused",
	"jaopca:thermal_expansion.dust_to_material.twinite",
	"jaopca:storage_blocks.to_material.wood",
    "thermal_extra:machine/crucible/raw_aluminum_from_chunk",
    "thermal_extra:machine/crucible/raw_arcane_gold_from_chunk",
    "sophisticatedstorage:backpack_stack_upgrade_omega_tier_from_storage_stack_upgrade_omega_tier",
    "sophisticatedstorage:storage_stack_upgrade_omega_tier_from_backpack_stack_upgrade_omega_tier",
    "sophisticatedstorage:stack_upgrade_omega_tier",
    "sophisticatedbackpacks:stack_upgrade_omega_tier",
    "architects_palette:ender_pearl_from_block",
    "architects_palette:ender_pearl_block"
]

// Advance Remove
// - Provide multiple options to target the removal
// - Removes the base version and adds it as '_manual_only' in order to fix Create issues (set 'manual' property to true)
// - To use regex when targeting ids (for dynamic recipes), use '$' in the start of the id
const advRemoval = [
	// This is a fix for a crash when opening the 'Automated Shaped Crafting' for the Ender Storage recipes
	{ output: "enderstorage:ender_pouch", manual: true },
	{ output: "enderstorage:ender_chest", manual: true },
	{ output: "enderstorage:ender_tank", manual: true },
	
	// Fixes the Alkahestry Tome with Create
	{ input: "reliquary:alkahestry_tome", manual: true }
]

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// The remove event
ServerEvents.recipes(event => {
	// Run the normal removes
    byOutput.forEach(item => event.remove({ output: item }));
    byId.forEach(item => event.remove({ id: item }));
	
	// Run the advance removes
	advRemoval.forEach(condition => {
		let manual = condition.manual;
		let test = condition.test;
		
		if (manual)
		{
			delete(condition.manual);
			
			let recipes = event.findRecipes(condition);
			recipes.forEach(recipe => {
				if (recipe.getId().endsWith("_manual_only"))
					return;
				
				recipe.id(recipe.getId() + "_manual_only");
			});
		}
		else		
			event.remove(condition);
	});
});